﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

namespace GE.Message
{
    /// <summary>
    /// Represents a message in the message system.
    /// </summary>
    class Message
    {
        /// <summary>
        /// Index.
        /// </summary>
        private int m_index;

        /// <summary>
        /// Message type.
        /// </summary>
        private MessageType m_type;

        /// <summary>
        /// Receiver.
        /// </summary>
        private MessageReceiver m_receiver;

        /// <summary>
        /// Field A.
        /// </summary>
        private float m_a;

        /// <summary>
        /// Field B.
        /// </summary>
        private float m_b;

        /// <summary>
        /// Field C.
        /// </summary>
        private float m_c;

        /// <summary>
        /// Field D.
        /// </summary>
        private float m_d;

        /// <summary>
        /// Index.
        /// </summary>
        public int Index
        {
            get
            {
                return m_index;
            }
            set
            {
                m_index = value;
            }
        }

        /// <summary>
        /// Message type.
        /// </summary>
        public MessageType Type
        {
            get
            {
                return m_type;
            }
            set
            {
                m_type = value;
            }
        }

        /// <summary>
        /// Receiver.
        /// </summary>
        public MessageReceiver Receiver
        {
            get
            {
                return m_receiver;
            }
            set
            {
                m_receiver = value;
            }
        }

        /// <summary>
        /// Field A.
        /// </summary>
        public float A
        {
            get
            {
                return m_a;
            }
            set
            {
                m_a = value;
            }
        }

        /// <summary>
        /// Field B.
        /// </summary>
        public float B
        {
            get
            {
                return m_b;
            }
            set
            {
                m_b = value;
            }
        }

        /// <summary>
        /// Field C.
        /// </summary>
        public float C
        {
            get
            {
                return m_c;
            }
            set
            {
                m_c = value;
            }
        }

        /// <summary>
        /// Field D.
        /// </summary>
        public float D
        {
            get
            {
                return m_d;
            }
            set
            {
                m_d = value;
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="index">index</param>
        /// <param name="type">type</param>
        /// <param name="receiver">receiver</param>
        public Message(int index, MessageType type, MessageReceiver receiver)
        {
            m_index = index;
            m_type = type;
            m_receiver = receiver;
            m_a = 0f;
            m_b = 0f;
            m_c = 0f;
            m_d = 0f;
        }
    }
}
